(*********************************************
TAsteroid->TPolygonSprite

Rotating asteroids that come in 3 sizes.  When
an large or medium sized asteroid is destroyed,
it breaks apart, creating 2-3 smaller asteroid
chunks.
*********************************************)

unit Asteroid;

interface

uses
  SysUtils, WinTypes, WinProcs, Classes, Graphics, Controls, TurboSprite,
  Sprites, Grafix;

const
  PTS_BIG = 24;
  DATA_BIG: array[0..PTS_BIG * 2 - 1] of integer =
  (16,0,24,0,24,5,27,2,36,9,34,12,38,13,40,24,33,25,38,28,31,36,29,35,28,40,16,40,18,35,10,37,2,28,5,26,0,24,0,16,5,16,1,10,10,4,14,5);
  PTS_MEDIUM = 21;
  DATA_MEDIUM: array[0..PTS_MEDIUM * 2 - 1] of integer =
  (17,9,23,9,23,12,25,11,30,16,27,19,31,19,31,23,28,27,25,26,23,31,17,31,17,27,15,29,10,25,12,23,9,21,9,17,11,15,14,16,13,12);
  PTS_SMALL = 18;
  DATA_SMALL: array[0..PTS_SMALL * 2 - 1] of integer =
  (18,12,22,12,22,15,25,14,28,18,26,20,28,22,25,26,23,24,22,28,18,28,18,25,16,26,13,22,15,21,12,19,14,15,18,16);

type

  TAsteroidSize = ( asBig, asMedium, asSmall );
  TIntArray = array[0..1] of integer;
  PIntArray = ^TIntArray;
  PPoint = ^TPoint;

  TAsteroid = class( TPolygonSprite )
  private
     FSize: TAsteroidSize;
  protected
     procedure addVertices; override;
     function getScore: integer;
  public
     property Score: integer read getScore;
     property Size: TAsteroidSize read FSize;
     constructor CreateAsteroid( MoveProc: TMoveProc; color: byte; nSize: TAsteroidSize );
     destructor Destroy; override;
  end;

implementation

uses
  Main;

var
  lstBig, lstMedium, lstSmall: TList;

procedure fillList( lst: TList; Num: integer; ar: PIntArray );
var
  i: integer;
  v: PPoint;
begin
  i := 0;
  while (i < Num * 2) do
  begin
    New( v );
    v^.X := ar^[i] - 20;
    v^.Y := ar^[i + 1] - 20;
    lst.add( v );
    Inc( i, 2 );
  end;
end;

procedure clearList( lst: TList );
begin
  while (lst.Count > 0) do
  begin
    Dispose( PPoint( lst[0] ) );
    lst.Delete( 0 );
  end;
end;

constructor TAsteroid.CreateAsteroid( MoveProc: TMoveProc; color: byte; nSize: TAsteroidSize );
begin
  FSize := nSize;
  inherited CreatePolygonSprite( MoveProc, color );
  case FSize of
    asBig:
      Speed := Random + Random;
    asMedium:
      Speed := Random( 3 ) + Random;
    asSmall:
      Speed := Random( 5 ) + Random;
  end;
  MarginLeft := 2;
  MarginTop := 2;
  MarginRight := 2;
  MarginBottom := 2;
  SpinSpeed := Random( 10 );
  SpinType := TSpinType( Random( 3 ) );
end;

destructor TAsteroid.Destroy;
var
  i: integer;
  ast: TAsteroid;
begin
  if Size <> asSmall then
  begin
    for i := 1 to Random(2) + 2 do
    begin
      ast := TAsteroid.CreateAsteroid( FMoveProc, FColorIndex, Succ(Size) );
      ast.Position := Position;
      ast.Destination := SpriteSurface.randomPoint;
      FSpriteEngine.addSprite( ast );
    end;
  end;
  inherited Destroy;
end;

procedure TAsteroid.addVertices;
  procedure fill( lst: TList );
  var
    i: integer;
    v: PPoint;
  begin
    for i := 0 to lst.Count - 1 do
    begin
      v := lst.Items[i];
      poly.addPoint( v^ );
    end;
  end;
begin
  case FSize of
    asBig:
      fill( lstBig );
    asMedium:
      fill( lstMedium );
    asSmall:
      fill( lstSmall );
  end;
end;

(*********************************************
The score gained when an asteroid is destroyed.
*********************************************)
function TAsteroid.GetScore: integer;
begin
  case FSize of
    asBig:
      Result := 50;
    asMedium:
      Result := 100;
    asSmall:
      Result := 250;
  end;
end;

initialization

lstBig := TList.Create;
lstMedium := TList.Create;
lstSmall := TList.Create;
fillList( lstBig, PTS_BIG, @DATA_BIG );
fillList( lstMedium, PTS_MEDIUM, @DATA_MEDIUM );
fillList( lstSmall, PTS_SMALL, @DATA_SMALL );

finalization

clearList( lstBig );
clearList( lstMedium );
clearList( lstSmall );
lstBig.Free;
lstMedium.Free;
lstSmall.Free;

end.
